/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	AnimControl
**
** DESCRIPTION:	Control the current animation of a villager
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ANIM_CONTROL_H
#define ANIM_CONTROL_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "AnimManager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAnimControl
{
private:

	//class data
	EAnim			m_eAnim;
	float			m_fTime;
	float			m_fSpeed;
	bool			m_bIsReversed;
	int				m_iPrevTime;
	bool			m_bFirstFrame;

	//class methods
	//setup
	public:		CAnimControl(void);
	public:		void Reset();

	//process
	public:		void Update(EAnimFrame &eAnimFrame, EHeadDirection &eHeadDirection, EDirection &eDirection);
	public:		void Play(const EAnim eAnim, const bool bIsReversed = false, const float fSpeed = 0.0f);
	public:		void Stop();

	//access
	public:		void SetSpeed(const float fSpeed);
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/